#include <string>
using namespace std;

/**
 * Base-class for reference-counted objects. When created,
 * the reference count is set to 1. After that, use
 * addRef() and release() to alter the internal count.
 */
class RefObject {
public:
  RefObject() {
    refs = 1;
  }

  // Add a reference.
  void addRef() { refs++; }

  // Release our reference.
  void release() {
    if (--refs == 0)
      delete this;
  }

private:
  // Current number of references to this object.
  int refs;

  // Let's declare this as private to disallow users of RefObjects to do
  // delete refObject!
  void operator delete(void *mem) { delete mem; }
};

/**
 * Another class we want to be reference counted.
 */
class MyObject : public RefObject {
public:
  string data;
};


int main() {
  MyObject *o = new MyObject;
  o->data = "Hello!";
  o->release();

  return 0;
}
