#include <iostream>
#include <cstring>

using namespace std;

typedef size_t nat;

// Call the function 'fn', with a dynamic list of parameters.
nat callFn(void *fn, nat count, nat *params) {
  nat pSize = count * sizeof(void *);
  nat *stack;
  nat result;

#if defined(_M_IX86)
  __asm mov stack, esp;
#elif defined(__i386__)
  __asm__ ("movl %%esp, %0;\n" : "=r"(stack)::);
#else
#error "NOT SUPPORTED, only works on x86!"
#endif

  // Copy parameters to the stack.
  nat *to = stack - count;
  memcpy(to, params, pSize);

#if defined(_M_IX86)
  __asm {
    sub esp, pSize;
    call fn;
    add esp, pSize;
    mov result, eax;
  };
#elif defined(__i386__)
  __asm__ ("subl %1, %%esp;\n"
	   "call *%2;\n"
	   "add %1, %%esp;\n"
	   "mov %%eax, %0;\n"
	   : "=r"(result)
	   : "r"(pSize), "r"(fn) : "memory");
#endif

  return result;
}


// Simple functions that add some parameters.
nat add1(nat a) { return a; }
nat add2(nat a, nat b) { return a + b; }
nat add3(nat a, nat b, nat c) { return a + b + c; }
nat add4(nat a, nat b, nat c, nat d) { return a + b + c + d; }
nat add5(nat a, nat b, nat c, nat d, nat e) { return a + b + c + d + e; }


// Test it!
int main() {
  nat numbers[] = { 1, 2, 3, 4, 5, 6 };
  cout << "1: " << callFn((void *)add1, 1, numbers) << endl;
  cout << "2: " << callFn((void *)add2, 2, numbers) << endl;
  cout << "3: " << callFn((void *)add3, 3, numbers) << endl;
  cout << "4: " << callFn((void *)add4, 4, numbers) << endl;
  cout << "5: " << callFn((void *)add5, 5, numbers) << endl;

  return 0;
}
