#include <iostream>
#include <stdarg.h>

using namespace std;

/**
 * Tracks lifetime, and keeps a simple value.
 */
class Lifetime {
public:

  Lifetime(int d) : data(d), id(counter++) {
    cout << "- created " << id << "(" << d << ")" << endl;
  }

  Lifetime(const Lifetime &o) : data(o.data), id(counter++) {
    cout << "- copied " << o.id << " to " << id << endl;
  }

  ~Lifetime() {
    cout << "- deleted " << id << endl;
  }

  // Our data.
  int data;

  // Our id
  int id;

  // ID counter (to uniqely identify objects).
  static int counter;
};

int Lifetime::counter = 0;

// Sum 'count' # of Lifetime objects.
int sumVa(int count, ...) {
  va_list l;
  va_start(l, count);

  int r = 0;
  for (int i = 0; i < count; i++) {
    cout << "Adding parameter " << i << endl;
    Lifetime lt = va_arg(l, Lifetime);
    r += lt.data;
  }

  va_end(l);
  cout << "Done adding" << endl;
  return r;
}

// Sum 2 Lifetime objects.
int sum(Lifetime a, Lifetime b) {
  int r = 0;
  {
    cout << "Adding parameter 1" << endl;
    Lifetime lt = a;
    r += lt.data;
  }

  {
    cout << "Adding parameter 2" << endl;
    Lifetime lt = b;
    r += lt.data;
  }

  cout << "Done adding" << endl;
  return r;
}

void variableArgs() {
  Lifetime a(1), b(2);
  cout << "Calling function" << endl;
  int s = sumVa(2, a, b);
  cout << "The sum is: " << s << endl;
}

void staticArgs() {
  Lifetime a(1), b(2);
  cout << "Calling function" << endl;
  int s = sum(a, b);
  cout << "The sum is: " << s << endl;
}

// Test the code!
int main() {
  cout << "Static args:" << endl;
  staticArgs();

  Lifetime::counter = 0;
  cout << endl << "Variable args:" << endl;
  variableArgs();

  return 0;
}
