#include <iostream>
#include <vector>
using namespace std;

/**
 * Helper for output pointers and regular values.
 */

template <class T>
struct Output {
  void operator() (const T &value) {
    cout << "Value     : " << value << endl;
  }
};

template <class T>
struct Output<T *> {
  void operator() (const T *value) {
    cout << "Pointer to: " << *value << endl;
  }
};


/**
 * Container interface, we can store any value in a container! They are
 * stored by reference, so make sure to retain the original copy of the
 * value on the stack!
 */

class Container {
public:
  virtual void output() const = 0;
};

template <class T>
class ContainerI : public Container {
public:
  ContainerI(const T &obj) : data(obj) {}

  const T &data;

  virtual void output() const {
    Output<T> t;
    t(data);
  }
};

template <class T>
Container *contain(const T &v) {
  return new ContainerI<T>(v);
}


int main() {
  int v1 = 128;
  int v2 = 256;
  int v3 = 512;

  vector<Container*> c;
  c.push_back(contain(v1));
  c.push_back(contain(&v1));
  c.push_back(contain(v2));
  c.push_back(contain(&v2));
  c.push_back(contain(v3));
  c.push_back(contain(&v3));

  for (size_t i = 0; i < c.size(); i++)
    c[i]->output();

  for (size_t i = 0; i < c.size(); i++)
    delete c[i];
  
  return 0;
}
